<?php
/**
 * Список существующих в системе счетов
 */
if( $curl = curl_init() ) 
{
	// Массив с GET параметрами запроса
	$array_query = array(
					// API KEY
					'key' => '7ec4425588bb84f502ac4eeaf6d7b79f',
	
					// Передаем критерии поиска
					'search[creation_date_start]' => '2014-06-01 00:00:00', // Дата создания счета От
					'search[creation_date_end]'=>'2014-07-01 00:00:00', // Дата создания счета До
					
					// Передаем настройки сортировки
					'param[sort]'=>'date_of_order ASC', // Сортируем по возрастанию. Поле: Дата создания счета
					
					// Указываем дополнительные настройки выборки
					'param[pagesize]'=>'10', // Выводить по 10 элементов на стройке
					'param[currentpage]'=>'2', // Показать 2-ю строку
	);
	 

	curl_setopt($curl, CURLOPT_URL, 'https://stores.autokassir.ru/?r=api/rest/accounts&'.http_build_query($array_query));
    curl_setopt($curl, CURLOPT_RETURNTRANSFER,true);
	curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
	
    $out_json = curl_exec($curl);
	
    curl_close($curl);
	
	// Декодирует JSON строку в объект с данными
	$out_obj = json_decode($out_json);
	
	// Если не получили объект с данными, то выводим сообщение об ошибке
	if(!is_array($out_obj))
	{
		echo $out_json;
		exit();
	}
	
	// Вывод полученных данных в окне браузера
	foreach($out_obj as $key => $obj)
	{
		echo '<hr />';
		echo '<br />ID: '.$obj->id_account;
		echo '<br />№: '.$obj->account_number;
		echo '<br />Код статуса счета: '.$obj->id_account_status; // см. справочник Статусы счета
		echo '<br />Дата заказа: '.$obj->date_of_order;
		echo '<br />Дата оплаты: '.$obj->date_of_payment;
		echo '<br />Код контакта: '.$obj->id_contact;  
		echo '<br />Email заказчика: '.$obj->email;
		echo '<br />Сумма: '.$obj->account_sum;
		echo '<br />Код способа оплаты: '.$obj->id_payment_system; // см. справочник Платежные системы
	}
}
?>